from datetime import datetime

from resources.lib.const import REGION, SEASONAL_EVENT


class SeasonalEvent:
    def __init__(self, name, start_date, end_date):
        self.name = name
        self.start_date = start_date
        self.end_date = end_date


class SeasonalEventManager:
    def __init__(self, region):
        self.region = region
        self.region_events = []

    def _build(self, date):
        eu = [
            SeasonalEvent(SEASONAL_EVENT.CHRISTMAS, datetime(date.year, 1, 1), datetime(date.year, 1, 6)),
            SeasonalEvent(SEASONAL_EVENT.CHRISTMAS, datetime(date.year, 12, 20), datetime(date.year, 12, 31, 23, 59, 59)),
        ]
        region_map = {
            REGION.CZECHIA: eu,
            REGION.SLOVAKIA: eu,
            REGION.CENTRAL_EUROPE: eu,
        }
        self.region_events = region_map.get(self.region, [])

    def current_events(self):
        now = datetime.now()
        self._build(now)
        current_events = [event for event in self.region_events if event.start_date <= now <= event.end_date]
        return current_events

